<?php
header("Content-Type: application/json");
header("Access-Control-Allow-Origin: *");
header("Access-Control-Allow-Methods: POST, GET, OPTIONS");
header("Access-Control-Allow-Headers: Content-Type");

if ($_SERVER['REQUEST_METHOD'] == 'OPTIONS') {
    http_response_code(200);
    exit();
}

// Configuración de la base de datos
$host = 'localhost';
$dbname = 'automate_bd_datos';
$username = 'root'; // Cambiar por tu usuario MySQL
$password = ''; // Cambiar por tu contraseña MySQL

try {
    $pdo = new PDO("mysql:host=$host;dbname=$dbname;charset=utf8", $username, $password);
    $pdo->setAttribute(PDO::ATTR_ERRMODE, PDO::ERRMODE_EXCEPTION);
} catch(PDOException $e) {
    http_response_code(500);
    echo json_encode([
        "success" => false,
        "message" => "Error de conexión a la base de datos"
    ]);
    exit();
}

if ($_SERVER['REQUEST_METHOD'] == 'POST') {
    $input = json_decode(file_get_contents('php://input'), true);
    
    if (!isset($input['email']) || !isset($input['password'])) {
        http_response_code(400);
        echo json_encode([
            "success" => false,
            "message" => "Email y contraseña son requeridos"
        ]);
        exit();
    }
    
    $email = trim($input['email']);
    $password = trim($input['password']);
    
    try {
        // Buscar usuario en tabla test_users
        $stmt = $pdo->prepare("
            SELECT id, username, password, email
            FROM test_users 
            WHERE email = ?
        ");
        $stmt->execute([$email]);
        $user = $stmt->fetch(PDO::FETCH_ASSOC);
        
        if ($user && password_verify($password, $user['password'])) {
            // Login exitoso
            echo json_encode([
                "success" => true,
                "message" => "Login exitoso",
                "user" => [
                    "id" => $user['id'],
                    "username" => $user['username'],
                    "email" => $user['email']
                ]
            ]);
        } else {
            // Credenciales incorrectas
            http_response_code(401);
            echo json_encode([
                "success" => false,
                "message" => "Email o contraseña incorrectos"
            ]);
        }
    } catch(PDOException $e) {
        http_response_code(500);
        echo json_encode([
            "success" => false,
            "message" => "Error del servidor"
        ]);
    }
} else {
    http_response_code(405);
    echo json_encode([
        "success" => false,
        "message" => "Método no permitido"
    ]);
}
            // Login exitoso
            http_response_code(200);
            echo json_encode([
                "success" => true,
                "message" => "Login exitoso",
                "user" => [
                    "id" => $user['id'],
                    "first_name" => $user['first_name'],
                    "last_name" => $user['last_name'],
                    "email" => $user['email'],
                    "birth_date" => $user['birth_date'],
                    "created_at" => $user['created_at'],
                    "is_email_verified" => (bool)$user['is_email_verified'],
                    "interests" => $user['interests'] ?? ""
                ]
            ]);
        } else {
            // Credenciales incorrectas
            http_response_code(401);
            echo json_encode(["error" => "Email o contraseña incorrectos"]);
        }
        
    } catch(PDOException $e) {
        http_response_code(500);
        echo json_encode(["error" => "Error del servidor"]);
    }
    
} else {
    http_response_code(405);
    echo json_encode(["error" => "Método no permitido"]);
}
?>
